#region AuthorHeader
//
//	EvoSystem version 2.1, by Xanthos. Edited by Vinz Clortho
//
//  Mercenary is based on a concept by Raelis, Sadoul and Grae
//
#endregion AuthorHeader
using System;
using Server;
using Server.Items;
using Server.Mobiles;
using Server.Network;
using Server.Misc;
using Server.SkillHandlers;
using System.Collections;
using System.Collections.Generic;
using Server.Targeting;
using Xanthos.Utilities;
using Xanthos.Interfaces;

namespace Xanthos.Evo
{
	//[CorpseName("a mercenary corpse")]
	public class Mercenary : BaseEvo, IEvoCreature
	{
		[CommandProperty(AccessLevel.Administrator)]
		public new bool CanHue
		{
			get { return false; }
		}

		private static Hashtable s_Keywords;
		private static string s_Version = "EvoSystem version 2.1, by Xanthos";

		public override BaseEvoSpec GetEvoSpec()
		{
			return MercenarySpec.Instance;
		}

		public override BaseEvoEgg GetEvoEgg()
		{
			return null;
		}

		public override bool AddPointsOnDamage { get { return false; } }
		public override bool AddPointsOnMelee { get { return true; } }
		public override Type GetEvoDustType() { return null; }
		public override bool IsScaredOfScaryThings { get { return true; } }

		enum Commands { None = 0, Restyle, Dress, Undress, Mount, Dismount, Stats, Unload, List, Arm, Grab, Loot, Attack, Tithe, Help, Refresh, Last = Commands.Refresh, }

		static Mercenary()
		{
			string[] keyWords = { " ", "restyle", "dress", "undress", "mount", "dismount", "stats", "unload", "list", "arm", "grab", "loot", "attack", "tithe", "help", "refresh" };

			s_Keywords = new Hashtable(keyWords.Length, StringComparer.OrdinalIgnoreCase);

			for (int i = 0; i < keyWords.Length; ++i)
				s_Keywords[keyWords[i]] = i;
		}

		public Mercenary(string name)
			: base(name, AIType.AI_Melee, 0.01)
		{
			SpeechHue = Utility.RandomDyedHue();
			Hue = Utility.RandomSkinHue();
			Item hair = new Item(Utility.RandomList(0x203B, 0x2049, 0x2048, 0x204A));
			hair.Hue = Utility.RandomNondyedHue();
			hair.Layer = Layer.Hair;
			hair.Movable = false;
			AddItem(hair);

			if (Female = Utility.RandomBool())
				Body = 0x191;
			else
			{
				Body = 0x190;
				if (Utility.RandomBool())
				{
					Item beard = new Item(Utility.RandomList(0x203E, 0x203F, 0x2040, 0x2041, 0x204B, 0x204C, 0x204D));
					beard.Hue = hair.Hue;
					beard.Layer = Layer.FacialHair;
					beard.Movable = false;
					AddItem(beard);
				}
			}

			if (!(this is IEvoGuardian))
			{
				Item weapon;
				switch (Utility.Random(6))
				{
						case 0: weapon = new Kryss(); break;
						case 1: weapon = new Scimitar(); break;
						case 2: weapon = new WarAxe(); break;
						case 3: weapon = new Cutlass(); break;
						case 4: weapon = new HammerPick(); break;
						default: weapon = new WarFork(); break;
				}
				AddItem(weapon);
				AddItem(new Robe());
			}

			if (null == Backpack)
			{
				Container pack = new Backpack();
				pack.Movable = false;
				AddItem(pack);
			}
		}

		public Mercenary(Serial serial) : base(serial) { }

		public override FoodType FavoriteFood { get { return FoodType.Eggs | FoodType.Fish | FoodType.Meat | FoodType.FruitsAndVegies; } }

		protected override void PackSpecialItem()
		{
			Item item;

			// 			switch ( Utility.Random( 4 ) )
			// 			{
			// 				case 0:	item = (Item)new MercenaryDeed(); break;
			// 				case 1: item = (Item)new EtherealLlama(); break;
			// 				case 3: item = (Item)new HoodedShroudOfShadows(); break;
			// 				default: ((BallOfSummoning)(item = (Item)new BallOfSummoning())).Charges = 2000; break;
			// 			}
			if (Utility.RandomBool())
				((BallOfSummoning)(item = (Item)new BallOfSummoning())).Charges = 20;
			else
				item = (Item)new EtherealLlama();

			item.LootType = LootType.Blessed;
			PackItem(item);
		}

		protected override void Evolve(bool hatching)
		{
			base.Evolve(hatching);
			InvalidateProperties();
		}

		public override string ApplyNameSuffix(string suffix)
		{
			if (!Controlled)
				return "";

			MercenarySpec spec = GetEvoSpec() as MercenarySpec;

			if (null != spec && null != spec.Stages)
			{
				// 				if ( suffix.Length == 0 )
				suffix = GetMercTitle(spec, m_Stage);
				// 				else
				// 					suffix = String.Concat( suffix, " ", GetMercTitle( spec, m_Stage ) );
			}

			return base.ApplyNameSuffix(suffix);
		}

		private string GetMercTitle(MercenarySpec spec, int stage)
		{
			string title = "";

			if (0 <= m_Stage && m_FinalStage >= m_Stage)
			{
				if (m_Stage == m_FinalStage || m_Stage == m_FinalStage - 1)
				{
					if (ControlMaster != null)
					{
						title = ", " + spec.Stages[m_Stage].Title + " of " + ControlMaster.Name;
					}
					
					Fame = 15000;
					Karma = 15000;
				}
				else
					title = spec.Stages[m_Stage].Title; // + " of " + m_FinalStage + " of " + m_MaxTrainingStage + " of " + m_Stage
			}

			return title;
		}

		private string GetRestrictedUseTitle(bool isArtifact)
		{
			MercenarySpec spec = GetEvoSpec() as MercenarySpec;

			return null == spec || null == spec.Stages ? "a higher" : isArtifact ? spec.Stages[spec.ArtifactStage].Title : spec.Stages[spec.CraftedWeaponStage].Title;
		}

		private bool CanUseRestrictedItem(bool isArtifact)
		{
			MercenarySpec spec = GetEvoSpec() as MercenarySpec;

			return (null != spec && (isArtifact ? spec.ArtifactStage : spec.CraftedWeaponStage) <= m_Stage);
		}

		public override bool HandlesOnSpeech(Mobile from) { return true; }

		public override void OnSpeech(SpeechEventArgs e)
		{
			Mobile from = e.Mobile;

			if (ControlMaster != from || IsDeadPet)
			{
				base.OnSpeech(e);
				return;
			}

			object command = Commands.None;

			if (e.Speech.Length > "all ".Length && e.Speech.Substring(0, "all ".Length).ToLower() == "all ")
				command = s_Keywords[e.Speech.Substring("all ".Length)];
			else if (e.Speech.Length > Name.Length + 1 && e.Speech.Substring(0, Name.Length + 1).ToLower() == Name.ToLower() + ' ')
				command = s_Keywords[e.Speech.Substring(Name.Length + 1)];

			switch ((command == null ? (int)Commands.None : (int)command))
			{
				case (int)Commands.Restyle:
					from.SendGump(new Xanthos.Evo.HairstylistBuyGump(from, this));
					break;
				case (int)Commands.Dress:
					Say("Zkusim si nasadit vsechny veci v mem batohu.");
					{
						List<Server.Item> items = Backpack.Items;

						for (int i = items.Count - 1; i >= 0; --i)
						{
							Item item = (Item)items[i];

							if (item is BaseWeapon || item is BaseClothing || item is BaseArmor || item is BaseJewel)
							{
								Backpack.DropItem(item);
								OnDragDrop(from, item);
							}
						}
					}
					break;
				case (int)Commands.Undress:
					Say("Dam ti vse co mam obleceno.");
					{
						List<Server.Item> items = Items;

						for (int i = items.Count - 1; i >= 0; --i)
						{
							Item item = (Item)items[i];
							if (!(item is Container || item is IMountItem) && item.Layer != Layer.FacialHair && item.Layer != Layer.Hair)
								from.AddToBackpack(item);
						}
					}
					break;
				case (int)Commands.Mount:
					if (null == Mount)
					{
						if (this.Blessed)
							Say("Tak brzy po smrti nemuzu nasednout na kone.");
						else
						{
							IMount mount = FindMyMount(Backpack);

							if (null == mount)
								from.Target = new MountTarget(from, this);
							else
								mount.Rider = this;
						}
					}
					break;
				case (int)Commands.Dismount:
					DismountMerc();
					break;
				case (int)Commands.Stats:
					from.SendGump(new AnimalLoreGump(this));
					break;
				case (int)Commands.Unload:
					Say("Dam ti vse co mam ve svem batohu.");
					{
						List<Server.Item> items = Backpack.Items;

						for (int i = items.Count - 1; i >= 0; --i)
						{
							from.AddToBackpack((Item)items[i]);
						}
					}
					break;
				case (int)Commands.List:
					Say("V batohu mam tyto veci:");
					foreach (Item item in Backpack.Items)
					{
						if (null != item)
							Say("{0} {1}", item.Amount, item.GetType().Name);
					}
					break;
				case (int)Commands.Arm:
					{
						Item item = Backpack.FindItemByType(typeof(BaseWeapon));

						if (null == item)
							Say("Nemam u sebe zadnou zbran.");
						else
						{
							Backpack.DropItem(item);
							OnDragDrop(from, item);
						}
					}
					break;
				case (int)Commands.Grab:
					GrabItems(false);
					break;
				case (int)Commands.Loot:
					GrabItems(true);
					break;
				case (int)Commands.Tithe:
					{
						bool ankhInRange = false;

						foreach (Item item in GetItemsInRange(2))
						{
							if (item is AnkhEast || item is AnkhWest)
							{
								ankhInRange = true;
								break;
							}
						}

						if (!ankhInRange)
							Say("Musim byt blize ke krizi.");
						else
						{

							Container pack = Backpack;
							if (null != pack)
							{
								Item item = pack.FindItemByType(typeof(Gold));
								int tithe;

								if (null != item && item.Amount > 0 && pack.ConsumeTotal(typeof(Gold), (tithe = item.Amount)))
								{
									Emote("*Tithes gold as a sign of devotion.*");
									TithingPoints += tithe;
									PlaySound(0x243);
									PlaySound(0x2E6);
								}
							}
						}
						
						Say("Mam {0} tithing points.", TithingPoints);
					}
					break;
				case (int)Commands.Help:
					Say("Budu poslouchat tyto prikazy: restyle, dress, undress, mount, dismount, unload, list, arm, grab, loot, attack, tithe, refresh and stats.");
					break;
				case (int)Commands.Refresh:
					{
						if ( TithingPoints < 1 )
							Say("Nemam tithing points");
						else if ( Stam < StamMax )
						{
							int stamka = ( ( StamMax - Stam ) * 5 );
							
							if ( stamka > TithingPoints )
								stamka = TithingPoints;

							Stam += ( stamka / 5 );
							TithingPoints -= stamka;
							PlaySound( 654 );
							FixedParticles( 0x375A, 10, 15, 5010, EffectLayer.Waist );
						}
					}
					break;
				case (int)Commands.Attack:
					switch (Utility.Random(2))
					{
							case 0: new Server.Spells.Chivalry.DivineFurySpell(this, null).Cast(); break;
							case 1: new Server.Spells.Chivalry.ConsecrateWeaponSpell(this, null).Cast(); break;
					}
					goto default;
				default:
					base.OnSpeech(e);
					return;
			}
			e.Handled = true;
		}

		private DateTime m_NextBandage = DateTime.Now;
		private DateTime m_NextAbility = DateTime.Now;
		
		public override void OnThink()
		{
			base.OnThink();

			if (Hits < (HitsMax - (HitsMax / 4)) && DateTime.Now > m_NextBandage)
			{
				Item item = Backpack.FindItemByType(typeof(Bandage));
				Item eitem = Backpack.FindItemByType(typeof(EnhancedBandage));

				if (BandageContext.GetContext(this) == null && EnhancedBandageContext.GetContext(this) == null)
				{
					double healpause = ( ( this.Blessed ) ? 10.0 : 4.5);
					
					if (null != eitem && null != EnhancedBandageContext.BeginHeal(this, this))
					{
						eitem.Consume(1);
						m_NextBandage = DateTime.Now + TimeSpan.FromSeconds( healpause );
					}
					else if (null != item && null != BandageContext.BeginHeal(this, this))
					{
						item.Consume(1);
						m_NextBandage = DateTime.Now + TimeSpan.FromSeconds( healpause );
					}
				}
			}
			else if ( Combatant != null && DateTime.Now > m_NextAbility/*Spells.SpellHelper.CheckCombat( this )*/ )
			{
				if ( Utility.RandomBool() )
					WeaponAbility.SetCurrentAbility( this, ((BaseWeapon)Weapon).PrimaryAbility );
				else
					WeaponAbility.SetCurrentAbility( this, ((BaseWeapon)Weapon).SecondaryAbility );
				
				m_NextAbility = DateTime.Now + TimeSpan.FromMinutes( 0.1 + ( 2.0 * Utility.RandomDouble() ) );
			}

			if (Loyalty < BaseCreature.MaxLoyalty && ControlMaster != null/* && ControlMaster.Map == Map*/ )
			{
				Loyalty = BaseCreature.MaxLoyalty;
				Hunger = 20;
			}
		}

		// 		private void CheckFeedSelf()
		// 		{
		// 			if ( !IsDeadPet && null != Backpack )
		// 			{
		// 				Item item = Backpack.FindItemByType( typeof( Food ) );
		// 
		// 				if ( null == item )
		// 					return;
		// 
		// 				((Food)item).Eat( this ); Stam += 15;
		// 
		// 				if ( Loyalty < BaseCreature.MaxLoyalty && 0.5 >= Utility.RandomDouble() )
		// 				{
		// 					++Loyalty;
		// 					this.Emote( "*Looks happier.*" );
		// 
		// 					if ( IsBondable && !IsBonded )
		// 					{
		// 						Mobile master = ControlMaster;
		// 
		// 						if ( master != null && master.Skills[SkillName.AnimalTaming].Value >= MinTameSkill )
		// 						{
		// 							if ( BondingBegin == DateTime.MinValue )
		// 							{
		// 								BondingBegin = DateTime.Now;
		// 							}
		// 							else if ( (BondingBegin + BondingDelay) <= DateTime.Now )
		// 							{
		// 								IsBonded = true;
		// 								BondingBegin = DateTime.MinValue;
		// 								master.SendLocalizedMessage( 1049666 ); // Your pet has bonded with you!
		// 								InvalidateProperties();
		// 							}
		// 						}
		// 					}
		// 				}
		// 			}
		// 		}

		public void GrabItems(bool ignoreNoteriety)
		{
			ArrayList items = new ArrayList();
			bool rejected = false;
			bool lootAdded = false;

			Emote("*Sbira zlataky ze zeme*");

			foreach (Item item in GetItemsInRange(2))
			{
				if ( item.Movable && item is Gold )
					items.Add(item);
				else if (item is Corpse)
				{	// Either criminally loot any corpses or loot only corpses that we have rights to
					if ((ignoreNoteriety || NotorietyHandlers.CorpseNotoriety(this, (Corpse)item) != Notoriety.Innocent) && !(((Corpse)item).Owner is PlayerMobile ))
					{
						Emote("*Hleda zlataky v mrtvolach*");
						foreach (Item corpseItem in ((Corpse)item).Items)
						{
                      if ( corpseItem is Gold );
							     items.Add(corpseItem);
                  }
					}
				}
			}
			foreach (Item item in items)
			{
				if (!Backpack.CheckHold(this, item, false, true))
					rejected = true;
				else
				{
					bool isRejected;
					LRReason reason;

					NextActionTime = DateTime.Now;
					Lift(item, item.Amount, out isRejected, out reason);

					if (!isRejected)
					{
						Drop(this, Point3D.Zero);
						lootAdded = true;
					}
					else
					{
						rejected = true;
					}
				}
			}
			if (lootAdded)
				PlaySound(0x2E6); //drop gold sound
			if (rejected)
				Say("Neunesu vsechny veci.");
		}

		public override bool CheckGold(Mobile from, Item dropped)
		{
			if (dropped is Gold)
				return false;

			return base.CheckGold(from, dropped);
		}

		public void DismountMerc()
		{
			if (null != Mount)
			{
				IMount mount = FindMyMount(null);

				if (null != mount)
				{
					mount.Rider = null;
					if (mount is EtherealMount)
						Backpack.DropItem(mount as EtherealMount);
					else
						((BaseMount)mount).ControlOrder = OrderType.Follow;
				}
			}
		}

		public IMount FindMyMount(Container pack)
		{
			List<Server.Item> items = (null == pack) ? Items : pack.Items;

			foreach (Item item in items)
			{
				if (item is IMountItem)
					return ((IMountItem)item).Mount;

				else if (item.Layer == Layer.Mount)
					return (IMount)item;
			}
			return null;
		}

		public override bool OnDragDrop(Mobile from, Item dropped)
		{
			Item itemEquipped;

			if ((ControlMaster != from && this != from) || IsDeadPet)
				return base.OnDragDrop(from, dropped);
				
			if ( dropped is Item && ( dropped.BlessedFor != null && this.ControlMaster != dropped.BlessedFor ) )
			{
				from.SendMessage( "Tato vec neni pozehnana pro majitele zoldaka.");
				from.AddToBackpack(dropped);
				return false;
			}

			bool isArtifact = Xanthos.Utilities.Misc.IsArtifact(dropped);

			if ((Xanthos.Utilities.Misc.IsPlayerConstructed(dropped) || isArtifact) && !CanUseRestrictedItem(isArtifact))
			{
				from.SendMessage(Name + " musi dosahnout {0} urovne aby mohl pouzivat {1}.", GetRestrictedUseTitle(isArtifact), isArtifact ? "artefakty" : "vyrobene veci");
				from.AddToBackpack(dropped);
				return false;
			}

			if (dropped is Bandage || dropped is EnhancedBandage || dropped is Food)
			{
				Backpack.DropItem(dropped);
				from.SendMessage("You give " + Name + " supplies.");
				return true;
			}
			else if (dropped is BaseEvoDust)
			{
				BaseEvoDust dust = dropped as BaseEvoDust;

				if (null != dust)
				{
					int amount = (dust.Amount * 20);

					m_Ep += amount;
					PlaySound(665);
					Emote("*" + this.Name + " absorbs the " + dust.Name + " gaining " + amount + " experience points*");
					dust.Delete();
					return true;
				}
			}
			else if (dropped is Gold)
			{
				Backpack.DropItem(dropped);
				from.SendMessage(Name + " dostal{0} zlataky.", this.Female ? "a" : "");
				return true;
			}
			else if (dropped is BaseWeapon)
			{
				if (dropped is PracticeBow || dropped is PracticeKryss || dropped is PracticeSword || dropped is PracticeMace)
				{
					from.SendMessage("Zoldaci nemohou pouzivat treningove zbrane.");
					from.AddToBackpack(dropped);
					return false;
				}

				itemEquipped = FindItemOnLayer(Layer.TwoHanded);

				if (null != itemEquipped && ((BaseWeapon)dropped).CheckConflictingLayer(this, itemEquipped, Layer.TwoHanded))
				{
					from.AddToBackpack(itemEquipped);

					if (itemEquipped is BaseRanged || itemEquipped is NoAmmoRanged || itemEquipped is MagicRanged)
						((BaseCreature)this).AI = AIType.AI_Melee;
				}

				itemEquipped = FindItemOnLayer(Layer.OneHanded);
				if (null != itemEquipped && ((BaseWeapon)dropped).CheckConflictingLayer(this, itemEquipped, Layer.OneHanded))
					from.AddToBackpack(itemEquipped);

				itemEquipped = FindItemOnLayer(Layer.FirstValid);
				if (null != itemEquipped && ((BaseWeapon)dropped).CheckConflictingLayer(this, itemEquipped, Layer.FirstValid))
					from.AddToBackpack(itemEquipped);

				Backpack.DropItem(dropped);
				this.EquipItem(dropped);

				if (dropped is BaseRanged || dropped is NoAmmoRanged || dropped is MagicRanged)
				{
					DebugSay("Zmena na AI_Archer");
					((BaseCreature)this).AI = AIType.AI_Archer;
					//ChangeAIType( AIType.AI_Archer );
				}
				else
				{
					DebugSay("Zmena na AI_Melee");
					((BaseCreature)this).AI = AIType.AI_Melee;
				}

				((BaseCreature)this).ControlOrder = OrderType.Guard;
				// 				AddItem( dropped );
				from.SendMessage(Name + " dostal{0} zbran.", this.Female ? "a" : "");
				return true;
			}
			else if (dropped is BaseArmor)
			{
				BaseArmor armor = (BaseArmor)dropped;

				if (!armor.AllowMaleWearer && Body.IsMale)
				{
					from.SendLocalizedMessage(1010388); // Only females can wear this.
					from.AddToBackpack(armor);
				}
				else if (!armor.AllowFemaleWearer && Body.IsFemale)
				{
					from.SendMessage("Pouze muzi mohou toto pouzivat.");
					from.AddToBackpack(armor);
				}
				else
				{
					itemEquipped = FindItemOnLayer(dropped.Layer);
					if (null != itemEquipped)
						from.AddToBackpack(itemEquipped);

					Backpack.DropItem(dropped);
					this.EquipItem(dropped);
					// 					AddItem( dropped );
					from.SendMessage(Name + " dostal{0} brneni.", this.Female ? "a" : "");
					return true;
				}
			}
			else if (dropped is BaseClothing || dropped is BaseJewel)
			{
				if (null != (itemEquipped = FindItemOnLayer(dropped.Layer)))
					from.AddToBackpack(itemEquipped);

				Backpack.DropItem(dropped);
				this.EquipItem(dropped);
				// 				AddItem( dropped );
				from.SendMessage(Name + " dostal{0} {1}.", this.Female ? "a" : "", (dropped is BaseJewel ? "sperk" : "obleceni"));
				return true;
			}

			return base.OnDragDrop(from, dropped);
		}

		private bool HasRangedEquipped()
		{
			Item item = FindItemOnLayer(Layer.TwoHanded);

			return (item != null && (item is BaseRanged || item is NoAmmoRanged || item is MagicRanged));
		}

		// 		public override void OnItemAdded( Item item )
		// 		{
		// 			base.OnItemAdded( item );
		// 			if ( item is BaseRanged || item is NoAmmoRanged || item is MagicRanged )
		// 			{
		// 				DebugSay( "Zmena na AI_Archer" );
		// 				((BaseCreature)this).AI = AIType.AI_Archer;
		//             //ChangeAIType( AIType.AI_Archer );
		// //             RangeFight = 7;
		// 			}
		// 		}

		public override void OnItemRemoved(Item item)
		{
			base.OnItemRemoved(item);
			if (item is BaseRanged || item is NoAmmoRanged || item is MagicRanged)
			{
				DebugSay("Zmena na ChangeAIToDefault");
				((BaseCreature)this).AI = AIType.AI_Melee;
			}
		}

		public override int GetMaxResistance(ResistanceType type)
		{
			if (m_Stage < 3)
				return 60;
			else if (m_Stage == 3)
				return 70;
			else if (m_Stage == 4)
				return 75;
			else if (m_Stage == 5)
				return 85;
			else
				return 90;
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);
			writer.Write((int)0);
		}

		public override bool OnBeforeDeath()
		{
			if ( !IsBonded )
				return true;
			
			DismountMerc();
			Animate(22, 5, 1, true, false, 0);
			new MercenaryBlessTimer(this, 30.0).Start();
			Warmode = false;
			Combatant = null;
			Poison = null;

			ControlTarget = ControlMaster;
			ControlOrder = OrderType.Follow;
			
			for ( int i = 0; i < this.Skills.Length; ++i )	//Decrease all skills on merc.
			{
				if ( this.Skills[i].Base > 15.0 )
               this.Skills[i].Base -= 0.1;
         }

			List<Server.Item> items = Items;

			for (int i = items.Count - 1; i >= 0; --i)
			{
				Item item = (Item)items[i];
            if ( this.Backpack != null && item != null && ( item.BlessedFor != null && this.ControlMaster != item.BlessedFor ) )
               this.Backpack.DropItem( item );
			}
			
			return false;
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			int version = reader.ReadInt();
			if (HasRangedEquipped())
				((BaseCreature)this).AI = AIType.AI_Archer;
			// 				ChangeAIType( AIType.AI_Archer );
         
         if ( this.Blessed )
			{
				new MercenaryBlessTimer(this, 30.0).Start();
			}
		}
	}

	internal class MountTarget : Target
	{
		private Mercenary m_Merc;

		public MountTarget(Mobile from, Mercenary merc)
			: base(1, false, TargetFlags.None)
		{
			m_Merc = merc;
			from.SendMessage("Vyber zvire ktere ma " + m_Merc.Name + " osedlat.");
		}

		protected override void OnTarget(Mobile from, object obj)
		{
			DoOnTarget(from, obj, m_Merc);
		}

		public static void DoOnTarget(Mobile from, object o, Mercenary merc)
		{
			EtherealMount ethy = o as EtherealMount;
			if (null != ethy)
			{
				if (null != ethy.Rider)
					from.SendMessage("This ethereal mount is already in use by someone else.");

				else if (!ethy.IsChildOf(from.Backpack))
					from.SendMessage("Ethereal musi byt ve tvem batohu.");
				else
					ethy.Rider = merc;
			}
			else
			{
				BaseMount mount = o as BaseMount;

				if (null == mount)
					from.SendMessage("Toto neni osedlatelne zvire.");

				else if (null != mount.Rider)
					from.SendMessage("This mount is already in use by someone else.");

				else if (mount.ControlMaster != from)
					from.SendMessage("Toto zvire neni tvoje.");
				else
					mount.Rider = merc;
			}
		}
	}
}
